<?php
// --- AYAR: MÜŞTERİNİN YAZILIMINA BU SATIRI EKLEMESİ GEREKECEK ---
// Bu, yazılımın kendi mevcut versiyonudur.
define('YAZILIM_VERSIYONU', '1.0.0'); 
// -----------------------------------------------------------------

// Bu dosya, aktivasyon yapılmış bir lisansı kontrol eder.
$lisans_dosyasi = __DIR__ . '/.lic_key';
if (!file_exists($lisans_dosyasi)) { return; }

$lisans_kodu = trim(file_get_contents($lisans_dosyasi));

$cache_dosyasi = __DIR__ . '/.license_cache';
$cache_suresi = 43200; // 12 saatte bir kontrol etsin.

if (file_exists($cache_dosyasi) && (time() - filemtime($cache_dosyasi)) < $cache_suresi) {
    // Cache taze olsa bile session'da güncelleme bilgisi var mı diye kontrol et.
    if (isset($_SESSION['update_available'])) {
        showUpdateNotice();
    }
    return;
}

$domain = str_replace('www.', '', $_SERVER['SERVER_NAME']);
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, LISANS_SUNUCUSU_URL);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(['lisans_kodu' => $lisans_kodu, 'domain' => $domain]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
curl_close($ch);
$result = json_decode($response, true);

if (isset($result['status']) && $result['status'] === 'success') {
    file_put_contents($cache_dosyasi, time());

    // YENİ GÜNCELLEME KONTROLÜ
    $latest_version = $result['data']['latest_version'];
    $update_url = $result['data']['update_url'];

    // version_compare fonksiyonu ile versiyonları karşılaştırıyoruz
    if ($latest_version && version_compare($latest_version, YAZILIM_VERSIYONU, '>')) {
        // Yeni versiyon var! Bilgileri session'a kaydet.
        $_SESSION['update_available'] = [
            'version' => $latest_version,
            'url' => $update_url
        ];
    } else {
        // Yeni versiyon yok, session'ı temizle.
        unset($_SESSION['update_available']);
    }
    
} else {
    // Lisans geçersizse güncelleme session'ını da temizle
    unset($_SESSION['update_available']);

    $hata_mesaji = isset($result['message']) ? htmlspecialchars($result['message'], ENT_QUOTES, 'UTF-8') : 'Bilinmeyen bir lisans hatasıyla karşılaşıldı.';
    if(file_exists($cache_dosyasi)) unlink($cache_dosyasi);
    if(file_exists($lisans_dosyasi)) unlink($lisans_dosyasi);
    die("<div style='...'>... Lisans Hatası ...</div>"); // Hata mesajı div'i aynı
}

// GÜNCELLEME BİLDİRİMİNİ GÖSTERECEK YARDIMCI FONKSİYON
// Bu fonksiyon, müşterinin yazılımının header veya footer gibi bir bölümünde çağrılmalı.
function showUpdateNotice() {
    if (isset($_SESSION['update_available'])) {
        $update_info = $_SESSION['update_available'];
        echo "<div style='background-color: #007bff; color: white; padding: 15px; text-align: center; position: fixed; bottom: 0; width: 100%; z-index: 9999;'>";
        echo "Yazılımınız için yeni bir güncelleme (<strong>Versiyon " . htmlspecialchars($update_info['version']) . "</strong>) mevcut! ";
        echo "<a href='" . htmlspecialchars($update_info['url']) . "' target='_blank' style='color: white; font-weight: bold; text-decoration: underline;'>Hemen İndir</a>";
        echo "</div>";
    }
}

// Session'da güncelleme varsa ve fonksiyon henüz çağrılmadıysa, çağır.
if (isset($_SESSION['update_available'])) {
    showUpdateNotice();
}

?>