<?php
// Zaman aşımını engellemek için
set_time_limit(0); 

// Veritabanı bağlantımızı dahil edelim
// Bu dosya /cron/ içinde olduğu için, ../admin/inc/db.php yolunu kullanıyoruz
require_once __DIR__ . '/../admin/inc/db.php';

// --- AYARLAR ---
define('UYARI_GUNU', 15); // Lisansın bitimine kaç gün kala uyarı maili gönderilsin?
define('MAIL_GONDEREN_AD', 'Artuklu Soft Lisans Uyarı Sistemi');
define('MAIL_GONDEREN_ADRES', 'info@artuklusoft.com'); // Kendi sunucuna ait bir mail adresi yazmalısın.
// ----------------

echo "Cron Job baslatildi: " . date('Y-m-d H:i:s') . "\n";

// Süresi dolmak üzere olan ve daha önce uyarı gönderilmemiş lisansları bulalım.
// JOIN ile müşteri ve yazılım bilgilerini de alıyoruz.
$sql = "SELECT 
            l.id, l.bitis_tarihi,
            m.ad_soyad, m.email,
            y.yazilim_adi
        FROM 
            lisanslar l
        JOIN 
            musteriler m ON l.musteri_id = m.id
        JOIN 
            yazilimlar y ON l.yazilim_id = y.id
        WHERE 
            l.durum = 'aktif' 
            AND l.uyari_mail_gonderildi = 0 
            AND l.bitis_tarihi BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL " . UYARI_GUNU . " DAY)";

$result = $conn->query($sql);

if ($result === false) {
    die("SQL sorgu hatasi: " . $conn->error);
}

$gonderilen_mail_sayisi = 0;

if ($result->num_rows > 0) {
    while($lisans = $result->fetch_assoc()) {

        $musteri_email = $lisans['email'];
        $musteri_ad_soyad = $lisans['ad_soyad'];
        $yazilim_adi = $lisans['yazilim_adi'];
        $bitis_tarihi_formatli = date('d.m.Y', strtotime($lisans['bitis_tarihi']));

        // E-posta başlığını ve içeriğini oluşturalım
        $konu = "Lisans Süreniz Dolmak Üzere: " . $yazilim_adi;

        $mesaj = "
        <html>
        <body style='font-family: Arial, sans-serif;'>
            <h2>Değerli Müşterimiz " . $musteri_ad_soyad . ",</h2>
            <p>Kullanmakta olduğunuz <strong>" . $yazilim_adi . "</strong> yazılımına ait lisansınızın süresi <strong>" . $bitis_tarihi_formatli . "</strong> tarihinde dolacaktır.</p>
            <p>Yazılımınızı kesintisiz kullanmaya devam etmek için lütfen lisansınızı yenileyiniz.</p>
            <p>Destek ve yenileme işlemleri için bizimle iletişime geçebilirsiniz.</p>
            <p>Saygılarımızla,<br>Artuklu Soft Ekibi</p>
        </body>
        </html>";

        // E-posta başlık (header) ayarları
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= 'From: ' . MAIL_GONDEREN_AD . ' <' . MAIL_GONDEREN_ADRES . '>' . "\r\n";

        // Maili gönder
        if (mail($musteri_email, $konu, $mesaj, $headers)) {
            echo $musteri_email . " adresine uyari maili gonderildi.\n";

            // Mail gönderildiyse veritabanında işareti güncelle
            $update_stmt = $conn->prepare("UPDATE lisanslar SET uyari_mail_gonderildi = 1 WHERE id = ?");
            $update_stmt->bind_param("i", $lisans['id']);
            $update_stmt->execute();
            $update_stmt->close();

            $gonderilen_mail_sayisi++;
        } else {
            echo $musteri_email . " adresine mail gonderilemedi.\n";
        }
    }
} else {
    echo "Suresi dolmak uzere olan yeni lisans bulunamadi.\n";
}

echo "Islem tamamlandi. Toplam " . $gonderilen_mail_sayisi . " adet uyari maili gonderildi.\n";

$conn->close();
?>