<?php
// Bu dosyanın tek başına çalışmaması için bir kontrol
if (!defined('AKTIVASYON_SAYFASI')) {
    die('Doğrudan erişim engellendi.');
}

$hata_mesaji = '';
$lisans_dosyasi = __DIR__ . '/.lic_key'; // Lisans anahtarını saklayacağımız gizli dosya

// Form gönderilmişse
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['lisans_kodu'])) {
    
    $gelen_lisans_kodu = trim($_POST['lisans_kodu']);
    
    if (empty($gelen_lisans_kodu)) {
        $hata_mesaji = 'Lütfen lisans anahtarınızı girin.';
    } else {
        // Sunucudan domain adını al
        $domain = isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : 'domain_bulunamadi';
        $domain = str_replace('www.', '', $domain);

        // Lisans sunucusuna cURL ile bağlan
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, LISANS_SUNUCUSU_URL);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'lisans_kodu' => $gelen_lisans_kodu,
            'domain'      => $domain
        ]));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        $response = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($response, true);

        // Cevabı kontrol et
        if (isset($result['status']) && $result['status'] === 'success') {
            // BAŞARILI! Lisans kodunu dosyaya kaydet.
            if (file_put_contents($lisans_dosyasi, $gelen_lisans_kodu)) {
                // Başarıyla kaydedildi, sayfayı yeniden yükle.
                header("Location: index.php");
                exit;
            } else {
                $hata_mesaji = 'Lisans dosyası oluşturulamadı. Lütfen dosya yazma izinlerini (CHMOD) kontrol edin.';
            }
        } else {
            // BAŞARISIZ! Sunucudan gelen hata mesajını göster.
            $hata_mesaji = isset($result['message']) ? htmlspecialchars($result['message'], ENT_QUOTES, 'UTF-8') : 'Bilinmeyen bir hata oluştu.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yazılım Aktivasyonu - Artuklu Soft</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-dark: #111827; /* Tailwind Slate 900 */
            --card-dark: #1F2937; /* Tailwind Slate 800 */
            --border-dark: #374151; /* Tailwind Slate 700 */
            --text-light: #D1D5DB; /* Tailwind Gray 300 */
            --text-heading: #F9FAFB; /* Tailwind Gray 50 */
            --accent-blue: #3B82F6; /* Tailwind Blue 500 */
            --accent-blue-hover: #2563EB; /* Tailwind Blue 600 */
            --error-bg: rgba(239, 68, 68, 0.1); /* Tailwind Red 500 with opacity */
            --error-border: rgba(239, 68, 68, 0.4);
            --error-text: #F87171; /* Tailwind Red 400 */
        }
        body { 
            font-family: 'Inter', sans-serif;
            background-color: var(--bg-dark); 
            color: var(--text-light);
            display: flex; 
            justify-content: center; 
            align-items: center; 
            min-height: 100vh; 
            margin: 0;
        }
        .activation-container { 
            background-color: var(--card-dark); 
            padding: 40px; 
            border-radius: 12px; 
            border: 1px solid var(--border-dark);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            width: 100%; 
            max-width: 450px; 
            text-align: center;
            box-sizing: border-box;
            animation: fadeIn 0.6s ease-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        .logo-container {
            margin-bottom: 24px;
        }
        .logo-container img {
            max-width: 180px;
            height: auto;
            /* MEVCUT LOGONUZU KOYU TEMAYA UYDURMAK İÇİN BU KODU KULLANIYORUZ */
            /* Arkaplanı transparan bir logonuz varsa, bu satırı silebilirsiniz. */
            filter: invert(1) grayscale(100%) brightness(2);
        }
        h2 { 
            color: var(--text-heading); 
            margin-top: 0;
            margin-bottom: 8px;
            font-weight: 700;
            font-size: 24px;
        }
        p { 
            margin-bottom: 32px; 
            font-size: 16px;
            line-height: 1.5;
        }
        .form-group { 
            margin-bottom: 20px; 
        }
        input[type="text"] { 
            width: 100%; 
            padding: 12px; 
            background-color: var(--bg-dark);
            color: var(--text-light);
            border: 1px solid var(--border-dark); 
            border-radius: 8px; 
            box-sizing: border-box; 
            font-size: 16px; 
            text-align: center;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        input[type="text"]::placeholder {
            color: #6B7280; /* Tailwind Gray 500 */
        }
        input[type="text"]:focus {
            border-color: var(--accent-blue);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.4);
            outline: none;
        }
        button { 
            width: 100%; 
            padding: 12px; 
            background-color: var(--accent-blue);
            color: var(--text-heading);
            border: none; 
            border-radius: 8px; 
            cursor: pointer; 
            font-size: 16px; 
            font-weight: 600; 
            transition: background-color 0.2s;
        }
        button:hover { 
            background-color: var(--accent-blue-hover);
        }
        .error { 
            color: var(--error-text); 
            background-color: var(--error-bg); 
            border: 1px solid var(--error-border);
            border-radius: 8px; 
            padding: 12px; 
            margin-top: 24px; 
            text-align: center;
        }
        .footer-info {
            margin-top: 32px;
            font-size: 12px;
            color: #6B7280; /* Tailwind Gray 500 */
        }
        .footer-info a {
            color: #9CA3AF; /* Tailwind Gray 400 */
            text-decoration: none;
        }
        .footer-info a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="activation-container">
        
        <div class="logo-container">
            <img src="https://artuklusoft.com/LOGO.png" alt="Artuklu Soft Logo">
        </div>
        
        <h2>Yazılım Aktivasyonu</h2>
        <p>Lütfen size verilen lisans anahtarını girerek yazılımınızı etkinleştirin.</p>
        
        <form action="" method="post" autocomplete="off">
            <div class="form-group">
                <input type="text" name="lisans_kodu" placeholder="XXXX-XXXX-XXXX-XXXX" required>
            </div>
            <button type="submit">Aktive Et</button>
        </form>
        
        <?php if (!empty($hata_mesaji)): ?>
            <div class="error"><?php echo $hata_mesaji; ?></div>
        <?php endif; ?>

        <div class="footer-info">
            &copy; <?php echo date('Y'); ?> Artuklu Soft. Tüm hakları saklıdır. <br>
            Teknik sorunlar için <a href="https://www.artuklusoft.com/iletisim" target="_blank">destek</a> sayfamızı ziyaret edin.
        </div>
    </div>
</body>
</html>