<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: destek_talepleri.php");
    exit();
}
$talep_id = intval($_GET['id']);
$admin_id = 1; // Şimdilik varsayılan admin ID'si, giriş sisteminize göre ayarlanabilir.

// Admin yeni bir yanıt gönderdiyse
if (isset($_POST['yanit_gonder'])) {
    $mesaj = trim($_POST['mesaj']);
    if (!empty($mesaj)) {
        // 1. Yanıtı veritabanına ekle
        $stmt_yanit = $conn->prepare("INSERT INTO destek_yanitlari (talep_id, yanitlayan_tipi, yanitlayan_id, mesaj) VALUES (?, 'admin', ?, ?)");
        $stmt_yanit->bind_param("iis", $talep_id, $admin_id, $mesaj);
        $stmt_yanit->execute();
        $stmt_yanit->close();

        // 2. Ana talebin durumunu 'Cevaplandı' olarak güncelle
        $stmt_talep = $conn->prepare("UPDATE destek_talepleri SET durum = 'Cevaplandı' WHERE id = ?");
        $stmt_talep->bind_param("i", $talep_id);
        $stmt_talep->execute();
        $stmt_talep->close();

        // Sayfayı yenileyerek yeni mesajı göster
        header("Location: talep_detay.php?id=" . $talep_id);
        exit();
    }
}

// Talep durumunu değiştirme
if (isset($_POST['durum_degistir'])) {
    $yeni_durum = $_POST['durum'];
    $stmt_durum = $conn->prepare("UPDATE destek_talepleri SET durum = ? WHERE id = ?");
    $stmt_durum->bind_param("si", $yeni_durum, $talep_id);
    $stmt_durum->execute();
    $stmt_durum->close();
    header("Location: talep_detay.php?id=" . $talep_id);
    exit();
}


// Talep ana bilgilerini ve müşteri adını çek
$stmt_talep = $conn->prepare("SELECT dt.*, m.ad_soyad, m.email FROM destek_talepleri dt JOIN musteriler m ON dt.musteri_id = m.id WHERE dt.id = ?");
$stmt_talep->bind_param("i", $talep_id);
$stmt_talep->execute();
$talep_result = $stmt_talep->get_result();
if ($talep_result->num_rows !== 1) {
    header("Location: destek_talepleri.php");
    exit();
}
$talep = $talep_result->fetch_assoc();
$stmt_talep->close();

// Taleple ilgili tüm yazışmaları çek
$yanitlar_sorgu = $conn->query("SELECT * FROM destek_yanitlari WHERE talep_id = $talep_id ORDER BY yanit_tarihi ASC");

?>
<style>
    .talep-grid { display: grid; grid-template-columns: 2fr 1fr; gap: 2rem; }
    .konusma-kutusu { display: flex; flex-direction: column; gap: 1rem; }
    .mesaj { padding: 1rem; border-radius: 0.75rem; max-width: 80%; }
    .mesaj .yazar { font-weight: bold; margin-bottom: 0.5rem; }
    .mesaj .tarih { font-size: 0.75rem; color: var(--text-light); margin-top: 0.5rem; }
    .mesaj-admin { background-color: var(--accent-blue-light); border: 1px solid rgba(59, 130, 246, 0.2); align-self: flex-end; color: #333; }
    .mesaj-musteri { background-color: var(--card-dark); border: 1px solid var(--border-dark); align-self: flex-start; }
    .yanit-formu textarea { width: 100%; min-height: 120px; padding: 0.75rem; background-color: var(--bg-dark); color: var(--text-light); border: 1px solid var(--border-dark); border-radius: 0.5rem; }
    .yanit-formu button { width: auto; padding: 0.75rem 1.5rem; }
    .talep-bilgileri td { padding: 0.5rem 0; }
    .talep-bilgileri td:first-child { color: var(--text-light); }
    @media (max-width: 900px) { .talep-grid { grid-template-columns: 1fr; } }
</style>

<div class="talep-grid">
    <div>
        <div class="card">
            <h2><?php echo htmlspecialchars($talep['konu']); ?></h2>
            <div class="konusma-kutusu">
                <?php while($yanit = $yanitlar_sorgu->fetch_assoc()): ?>
                    <div class="mesaj <?php echo ($yanit['yanitlayan_tipi'] == 'admin') ? 'mesaj-admin' : 'mesaj-musteri'; ?>">
                        <div class="yazar">
                            <?php echo ($yanit['yanitlayan_tipi'] == 'admin') ? 'Destek Ekibi' : htmlspecialchars($talep['ad_soyad']); ?>
                        </div>
                        <p><?php echo nl2br(htmlspecialchars($yanit['mesaj'])); ?></p>
                        <div class="tarih"><?php echo date('d.m.Y H:i', strtotime($yanit['yanit_tarihi'])); ?></div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
        <div class="card yanit-formu">
            <h3>Yanıt Yaz</h3>
            <form action="talep_detay.php?id=<?php echo $talep_id; ?>" method="post">
                <div class="form-group">
                    <textarea name="mesaj" required placeholder="Müşteriye cevabınızı buraya yazın..."></textarea>
                </div>
                <button type="submit" name="yanit_gonder">Yanıtı Gönder</button>
            </form>
        </div>
    </div>

    <div class="card">
        <h4>Talep Bilgileri</h4>
        <table class="talep-bilgileri">
            <tr><td>Talep ID:</td><td>#<?php echo $talep['id']; ?></td></tr>
            <tr><td>Müşteri:</td><td><?php echo htmlspecialchars($talep['ad_soyad']); ?></td></tr>
            <tr><td>E-posta:</td><td><?php echo htmlspecialchars($talep['email']); ?></td></tr>
            <tr><td>Öncelik:</td><td><?php echo htmlspecialchars($talep['oncelik']); ?></td></tr>
            <tr><td>Açılış Tarihi:</td><td><?php echo date('d.m.Y H:i', strtotime($talep['olusturma_tarihi'])); ?></td></tr>
        </table>
        
        <hr style="border-color: var(--border-dark); margin: 1.5rem 0;">

        <h4>Durumu Değiştir</h4>
        <form action="talep_detay.php?id=<?php echo $talep_id; ?>" method="post">
            <div class="form-group">
                <select name="durum">
                    <option value="Açık" <?php if($talep['durum'] == 'Açık') echo 'selected'; ?>>Açık</option>
                    <option value="Cevaplandı" <?php if($talep['durum'] == 'Cevaplandı') echo 'selected'; ?>>Cevaplandı</option>
                    <option value="Müşteri Yanıtladı" <?php if($talep['durum'] == 'Müşteri Yanıtladı') echo 'selected'; ?>>Müşteri Yanıtladı</option>
                    <option value="Kapatıldı" <?php if($talep['durum'] == 'Kapatıldı') echo 'selected'; ?>>Kapatıldı</option>
                </select>
            </div>
            <button type="submit" name="durum_degistir">Güncelle</button>
        </form>
    </div>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>