<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 
?>

<div class="card">
    <h2>API İşlem Logları</h2>
    <p>Lisans sunucunuza yapılan son 100 sorgulama girişimi aşağıda listelenmiştir.</p>
    <div style="overflow-x:auto;"> <table>
        <thead>
            <tr>
                <th>Tarih</th>
                <th>IP Adresi</th>
                <th>Denene Kod</th>
                <th>Denene Domain</th>
                <th>Sonuç</th>
                <th>Mesaj</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Veritabanından son 100 log'u çek
            $result = $conn->query("SELECT * FROM logs ORDER BY id DESC LIMIT 100");
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    // Sonuç durumuna göre renklendirme
                    $sonuc_class = '';
                    if ($row['sonuc'] == 'Basarili') {
                        $sonuc_class = 'color: #28a745;'; // Yeşil
                    } elseif (strpos($row['sonuc'], 'Hata') !== false) {
                        $sonuc_class = 'color: #dc3545;'; // Kırmızı
                    }

                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($row['islem_tarihi']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['ip_adresi']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['lisans_kodu_denemesi']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['domain_denemesi']) . "</td>";
                    echo "<td style='font-weight:bold; " . $sonuc_class . "'>" . htmlspecialchars($row['sonuc']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['mesaj']) . "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='6'>Henüz kaydedilmiş bir işlem bulunmuyor.</td></tr>";
            }
            ?>
        </tbody>
    </table>
    </div>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>