<?php
session_start();
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: index.php');
    exit;
}
require_once 'inc/db.php';
$error_message = '';
// ... (Giriş kontrolü yapan PHP kodunun geri kalanı aynı şekilde kalacak)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $kullanici_adi = trim($_POST['kullanici_adi']);
    $sifre = trim($_POST['sifre']);

    if (empty($kullanici_adi) || empty($sifre)) {
        $error_message = "Kullanıcı adı ve şifre boş bırakılamaz.";
    } else {
        $stmt = $conn->prepare("SELECT id, kullanici_adi, sifre_hash FROM admin_kullanicilar WHERE kullanici_adi = ?");
        $stmt->bind_param("s", $kullanici_adi);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows === 1) {
            $stmt->bind_result($id, $db_kullanici_adi, $db_sifre_hash);
            $stmt->fetch();
            if (password_verify($sifre, $db_sifre_hash)) {
                $_SESSION['admin_logged_in'] = true;
                $_SESSION['admin_username'] = $db_kullanici_adi;
                header("location: index.php");
                exit;
            } else { $error_message = "Geçersiz kullanıcı adı veya şifre."; }
        } else { $error_message = "Geçersiz kullanıcı adı veya şifre."; }
        $stmt->close();
    }
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yönetim Paneli Giriş</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-dark: #111827; --card-dark: #1F2937; --border-dark: #374151;
            --text-light: #D1D5DB; --text-heading: #F9FAFB; --accent-blue: #3B82F6;
            --accent-blue-hover: #2563EB; --error-text: #F87171;
        }
        body { font-family: 'Inter', sans-serif; background-color: var(--bg-dark); color: var(--text-light); display: flex; justify-content: center; align-items: center; min-height: 100vh; }
        .login-container { background-color: var(--card-dark); padding: 40px; border-radius: 12px; border: 1px solid var(--border-dark); width: 100%; max-width: 400px; text-align: center; }
        .logo { font-size: 2rem; font-weight: 700; margin-bottom: 1.5rem; color: var(--text-heading); }
        h2 { color: var(--text-heading); font-weight: 600; margin-bottom: 2rem; }
        .form-group { margin-bottom: 1.5rem; text-align: left; }
        label { display: block; margin-bottom: 0.5rem; font-weight: 500; }
        input[type="text"], input[type="password"] { width: 100%; padding: 0.75rem; background-color: var(--bg-dark); color: var(--text-light); border: 1px solid var(--border-dark); border-radius: 0.5rem; }
        button { width: 100%; padding: 0.75rem; background-color: var(--accent-blue); color: var(--text-heading); border: none; border-radius: 0.5rem; cursor: pointer; font-size: 1rem; font-weight: 600; }
        button:hover { background-color: var(--accent-blue-hover); }
        .error { color: var(--error-text); margin-top: 1.5rem; }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">Asoft Lisans Takip Sistemi</div>
        <h2>Yönetim Paneline Giriş Yap</h2>
        <form action="login.php" method="post">
            <div class="form-group">
                <label for="kullanici_adi">Kullanıcı Adı</label>
                <input type="text" name="kullanici_adi" id="kullanici_adi" required>
            </div>
            <div class="form-group">
                <label for="sifre">Şifre</label>
                <input type="password" name="sifre" id="sifre" required>
            </div>
            <button type="submit">Giriş Yap</button>
        </form>
        <?php if(!empty($error_message)): ?>
            <p class="error"><?php echo $error_message; ?></p>
        <?php endif; ?>
    </div>
</body>
</html>