<?php 
// 1. Session'ı başlat ve işlem kodunu header'dan önceye al
session_start();
require_once 'inc/db.php'; 

// Yeni kullanıcı ekleme
if (isset($_POST['kullanici_ekle'])) {
    $kullanici_adi = trim($_POST['kullanici_adi']);
    $sifre = trim($_POST['sifre']);

    if (!empty($kullanici_adi) && !empty($sifre)) {
        $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO admin_kullanicilar (kullanici_adi, sifre_hash) VALUES (?, ?)");
        $stmt->bind_param("ss", $kullanici_adi, $sifre_hash);
        if ($stmt->execute()) {
            header("Location: kullanicilar.php");
            exit();
        } else { $error = "Hata: Kullanıcı eklenemedi. Bu kullanıcı adı zaten mevcut olabilir."; }
        $stmt->close();
    } else { $error = "Kullanıcı adı ve şifre alanları boş bırakılamaz."; }
}

// Silme işlemi
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id_to_delete = intval($_GET['id']);
    // Ana admin (ID=1) silinemez
    if ($id_to_delete === 1) {
        $error = "Ana yönetici hesabı (ID 1) silinemez.";
    } else {
        $stmt = $conn->prepare("DELETE FROM admin_kullanicilar WHERE id = ?");
        $stmt->bind_param("i", $id_to_delete);
        if ($stmt->execute()) {
            header("Location: kullanicilar.php");
            exit();
        } else { $error = "Hata: Kullanıcı silinemedi."; }
        $stmt->close();
    }
}

// 2. HTML içeriğini başlatan dosyaları şimdi dahil et
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 
?>

<div class="card">
    <h2>Yeni Yönetici Ekle</h2>
    <?php if (isset($error)) { echo "<p style='color:red;'>$error</p>"; } ?>
    <form action="kullanicilar.php" method="post">
        <div class="form-group">
            <label for="kullanici_adi">Kullanıcı Adı</label>
            <input type="text" name="kullanici_adi" id="kullanici_adi" required>
        </div>
        <div class="form-group">
            <label for="sifre">Şifre</label>
            <input type="password" name="sifre" id="sifre" required>
        </div>
        <input type="submit" name="kullanici_ekle" value="Yöneticiyi Ekle">
    </form>
</div>

<div class="card">
    <h2>Yönetici Hesapları</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Kullanıcı Adı</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $result = $conn->query("SELECT id, kullanici_adi FROM admin_kullanicilar ORDER BY id ASC");
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $row['id'] . "</td>";
                    echo "<td>" . htmlspecialchars($row['kullanici_adi']) . "</td>";
                    echo "<td>
                            <a href='kullanici_duzenle.php?id=" . $row['id'] . "' style='margin-right:15px;'>Düzenle</a>";
                    // Ana admin (ID=1) için silme butonunu gösterme
                    if ($row['id'] != 1) {
                        echo "<a href='kullanicilar.php?action=delete&id=" . $row['id'] . "' onclick='return confirm(\"Bu kullanıcıyı silmek istediğinize emin misiniz?\")' class='btn-delete'>Sil</a>";
                    }
                    echo "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='3'>Hiç yönetici hesabı bulunmuyor.</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>