<?php
session_start();

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    if (basename($_SERVER['PHP_SELF']) != 'login.php') {
        header('Location: login.php');
        exit;
    }
}

// --- YENİ EKLENEN KISIM BAŞLANGICI ---
// Veritabanı bağlantısı header'da değilse, nav.php'den önce burada yapalım
if (!isset($conn)) {
    require_once 'db.php';
}
// Ayarları çek
$AYARLAR = [];
$result = $conn->query("SELECT ayar_key, ayar_value FROM ayarlar");
if($result){
    while ($row = $result->fetch_assoc()) {
        $AYARLAR[$row['ayar_key']] = $row['ayar_value'];
    }
}
// --- YENİ EKLENEN KISIM SONU ---

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($AYARLAR['site_adi']) ? htmlspecialchars($AYARLAR['site_adi']) : 'Lisans Yönetim Paneli'; ?></title>
    <?php if (!empty($AYARLAR['favicon']) && file_exists('../' . $AYARLAR['favicon'])): ?>
        <link rel="icon" type="image/png" href="../<?php echo htmlspecialchars($AYARLAR['favicon']); ?>">
    <?php endif; ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* ... CSS kodları aynı kalacak ... */
        :root {
            --bg-dark: #111827;
            --card-dark: #1F2937;
            --sidebar-dark: #1F2937;
            --border-dark: #374151;
            --text-light: #D1D5DB;
            --text-heading: #F9FAFB;
            --accent-blue: #3B82F6;
            --accent-blue-hover: #2563EB;
            --danger-red: #EF4444;
            --danger-red-hover: #DC2626;
        }
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Inter', sans-serif; background-color: var(--bg-dark); color: var(--text-light); font-size: 14px; }
        .container { display: flex; min-height: 100vh; }
        .content-wrapper { flex-grow: 1; display: flex; flex-direction: column; }
        
        .header-bar {
            background-color: var(--card-dark);
            border-bottom: 1px solid var(--border-dark);
            padding: 1rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-shrink: 0;
        }
        .header-bar .page-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--text-heading);
        }
        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        .user-menu span {
            font-weight: 500;
        }
        .user-menu .logout-btn {
            color: var(--text-light);
            background-color: var(--border-dark);
            text-decoration: none;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
            transition: background-color 0.2s, color 0.2s;
        }
        .user-menu .logout-btn:hover {
            background-color: var(--danger-red);
            color: var(--text-heading);
        }
        
        .main-content { padding: 2rem; overflow-y: auto; }
        .card { background-color: var(--card-dark); border: 1px solid var(--border-dark); border-radius: 0.75rem; padding: 1.5rem; margin-bottom: 2rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1), 0 2px 4px -2px rgba(0,0,0,0.1); }
        h1, h2 { color: var(--text-heading); margin-bottom: 1rem; font-weight: 600; }
        h1 { font-size: 1.5rem; }
        h2 { font-size: 1.25rem; }
        table { width: 100%; border-collapse: collapse; margin-top: 1.5rem; font-size: 0.875rem; }
        th, td { padding: 0.75rem 1rem; border-bottom: 1px solid var(--border-dark); text-align: left; }
        th { background-color: rgba(55, 65, 81, 0.5); color: var(--text-heading); font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em; }
        tbody tr:hover { background-color: #374151; }
        td a { color: var(--accent-blue); text-decoration: none; font-weight: 500; }
        td a:hover { text-decoration: underline; }
        .btn-delete { color: var(--danger-red); }
        .btn-delete:hover { color: var(--danger-red-hover); }
        .form-group { margin-bottom: 1rem; }
        label { display: block; margin-bottom: 0.5rem; font-weight: 500; color: var(--text-light); }
        input[type="text"], input[type="email"], input[type="password"], select { width: 100%; padding: 0.75rem; background-color: var(--bg-dark); color: var(--text-light); border: 1px solid var(--border-dark); border-radius: 0.5rem; transition: border-color 0.2s, box-shadow 0.2s; }
        input:focus, select:focus { border-color: var(--accent-blue); box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.4); outline: none; }
        input[type="submit"], button { width: 100%; padding: 0.75rem; background-color: var(--accent-blue); color: var(--text-heading); border: none; border-radius: 0.5rem; cursor: pointer; font-size: 0.875rem; font-weight: 600; transition: background-color 0.2s; }
        input[type="submit"]:hover, button:hover { background-color: var(--accent-blue-hover); }
        .actions-cell select { background-color: var(--border-dark); cursor: pointer; }
    </style>
</head>
<body>
<div class="container">