<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 

// Müşteri adlarını da alabilmek için JOIN ile sorgu yapıyoruz
$talepler_sorgu = $conn->query("
    SELECT dt.*, m.ad_soyad 
    FROM destek_talepleri dt
    JOIN musteriler m ON dt.musteri_id = m.id
    ORDER BY dt.son_guncelleme DESC
");
?>

<div class="card">
    <h2>Destek Talepleri</h2>
    <p>Müşterileriniz tarafından oluşturulan tüm destek taleplerini burada görebilirsiniz.</p>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Müşteri</th>
                <th>Konu</th>
                <th>Durum</th>
                <th>Öncelik</th>
                <th>Son Güncelleme</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($talepler_sorgu->num_rows > 0): ?>
                <?php while($talep = $talepler_sorgu->fetch_assoc()): ?>
                    <tr>
                        <td>#<?php echo $talep['id']; ?></td>
                        <td><?php echo htmlspecialchars($talep['ad_soyad']); ?></td>
                        <td><?php echo htmlspecialchars($talep['konu']); ?></td>
                        <td>
                            <span class="status-badge <?php echo strtolower(str_replace(' ', '', $talep['durum'])); ?>">
                                <?php echo htmlspecialchars($talep['durum']); ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($talep['oncelik']); ?></td>
                        <td><?php echo date('d.m.Y H:i', strtotime($talep['son_guncelleme'])); ?></td>
                        <td>
                            <a href="talep_detay.php?id=<?php echo $talep['id']; ?>">Görüntüle</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="7">Henüz oluşturulmuş bir destek talebi bulunmuyor.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<style>
    .status-badge { padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
    .status-badge.açık, .status-badge.müşteriyanıtladı { background-color: #fef3c7; color: #92400e; }
    .status-badge.cevaplandı { background-color: #d1fae5; color: #065f46; }
    .status-badge.kapatıldı { background-color: #e5e7eb; color: #4b5563; }
</style>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>