<?php
require_once '../admin/inc/db.php';

// --- YENİ LOGLAMA FONKSİYONU ---
function logAction($conn, $lisans_kodu, $domain, $ip, $sonuc, $mesaj) {
    $stmt = $conn->prepare("INSERT INTO logs (lisans_kodu_denemesi, domain_denemesi, ip_adresi, sonuc, mesaj) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $lisans_kodu, $domain, $ip, $sonuc, $mesaj);
    $stmt->execute();
    $stmt->close();
}
// ------------------------------------

header('Content-Type: application/json');

function sendResponse($status, $message, $data = array()) {
    echo json_encode(array('status' => $status, 'message' => $message, 'data' => $data));
    exit;
}

$ip_adresi = $_SERVER['REMOTE_ADDR'];
$lisans_kodu = isset($_POST['lisans_kodu']) ? trim($_POST['lisans_kodu']) : '';
$domain = isset($_POST['domain']) ? str_replace(array('http://', 'https://', 'www.'), '', trim($_POST['domain'])) : '';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    logAction($conn, $lisans_kodu, $domain, $ip_adresi, 'Hata', 'Gecersiz istek metodu.');
    sendResponse('error', 'Gecersiz istek metodu.');
}

if (empty($lisans_kodu) || empty($domain)) {
    logAction($conn, $lisans_kodu, $domain, $ip_adresi, 'Hata', 'Eksik parametre.');
    sendResponse('error', 'Eksik parametre.');
}

$stmt = $conn->prepare("SELECT l.durum, l.bitis_tarihi, y.guncel_versiyon, y.guncelleme_linki 
                        FROM lisanslar l
                        JOIN yazilimlar y ON l.yazilim_id = y.id
                        WHERE l.lisans_kodu = ? AND l.lisansli_domain = ?");
$stmt->bind_param("ss", $lisans_kodu, $domain);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 1) {
    $stmt->bind_result($durum, $bitis_tarihi, $guncel_versiyon, $guncelleme_linki);
    $stmt->fetch();

    if ($durum !== 'aktif') {
        logAction($conn, $lisans_kodu, $domain, $ip_adresi, 'Hata - Pasif', 'Lisans aktif degil. Durum: ' . strtoupper($durum));
        sendResponse('error', 'Lisansiniz aktif degildir. Durum: ' . strtoupper($durum));
    }

    $bugun = date('Y-m-d');
    if ($bugun > $bitis_tarihi) {
        logAction($conn, $lisans_kodu, $domain, $ip_adresi, 'Hata - Süresi Doldu', 'Lisansin suresi dolmus.');
        sendResponse('error', 'Lisansinizin suresi dolmustur.');
    }

    $update_stmt = $conn->prepare("UPDATE lisanslar SET son_kontrol_tarihi = NOW(), son_kontrol_ip = ? WHERE lisans_kodu = ?");
    $update_stmt->bind_param("ss", $ip_adresi, $lisans_kodu);
    $update_stmt->execute();
    $update_stmt->close();

    $data = array(
        'expires_at' => $bitis_tarihi,
        'latest_version' => $guncel_versiyon,
        'update_url' => $guncelleme_linki
    );
    logAction($conn, $lisans_kodu, $domain, $ip_adresi, 'Basarili', 'Lisans dogrulandi.');
    sendResponse('success', 'Lisans dogrulandi.', $data);
} else {
    logAction($conn, $lisans_kodu, $domain, $ip_adresi, 'Hata - Gecersiz', 'Gecersiz lisans kodu veya domain.');
    sendResponse('error', 'Gecersiz lisans kodu veya domain.');
}

$stmt->close();
$conn->close();
?>