<?php 
// 1. Session'ı başlat ve işlem kodunu header'dan önceye al
session_start();
require_once 'inc/db.php'; 

// Yeni yazılım ekleme
if (isset($_POST['yazilim_ekle'])) {
    $yazilim_adi = trim($_POST['yazilim_adi']);
    $guncel_versiyon = trim($_POST['guncel_versiyon']);
    $guncelleme_linki = trim($_POST['guncelleme_linki']);

    if (!empty($yazilim_adi)) {
        $stmt = $conn->prepare("INSERT INTO yazilimlar (yazilim_adi, guncel_versiyon, guncelleme_linki) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $yazilim_adi, $guncel_versiyon, $guncelleme_linki);
        if ($stmt->execute()) {
            header("Location: yazilimlar.php");
            exit();
        } else { $error = "Hata: Yazılım eklenemedi."; }
        $stmt->close();
    } else { $error = "Yazılım adı boş bırakılamaz."; }
}

// Silme işlemi
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id_to_delete = intval($_GET['id']);
    $stmt = $conn->prepare("DELETE FROM yazilimlar WHERE id = ?");
    $stmt->bind_param("i", $id_to_delete);
    if ($stmt->execute()) {
        header("Location: yazilimlar.php");
        exit();
    } else { $error = "Hata: Yazılım silinemedi."; }
    $stmt->close();
}

// 2. HTML içeriğini başlatan dosyaları şimdi dahil et
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 
?>

<div class="card">
    <h2>Yeni Yazılım Ekle</h2>
    <?php if (isset($error)) { echo "<p style='color:red;'>$error</p>"; } ?>
    <form action="yazilimlar.php" method="post">
        <div class="form-group">
            <label for="yazilim_adi">Yazılım Adı</label>
            <input type="text" name="yazilim_adi" id="yazilim_adi" required>
        </div>
        <div class="form-group">
            <label for="guncel_versiyon">Güncel Versiyon</label>
            <input type="text" name="guncel_versiyon" id="guncel_versiyon" placeholder="Örn: 1.0.0">
        </div>
        <div class="form-group">
            <label for="guncelleme_linki">Güncelleme İndirme Linki</label>
            <input type="text" name="guncelleme_linki" id="guncelleme_linki" placeholder="https://site.com/guncelleme.zip">
        </div>
        <input type="submit" name="yazilim_ekle" value="Yazılımı Ekle">
    </form>
</div>

<div class="card">
    <h2>Mevcut Yazılımlar</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Yazılım Adı</th>
                <th>Güncel Versiyon</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $result = $conn->query("SELECT * FROM yazilimlar ORDER BY id DESC");
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $row['id'] . "</td>";
                    echo "<td>" . htmlspecialchars($row['yazilim_adi']) . "</td>";
                    echo "<td><strong>" . htmlspecialchars($row['guncel_versiyon']) . "</strong></td>";
                    echo "<td>
                            <a href='yazilim_duzenle.php?id=" . $row['id'] . "' style='margin-right:15px;'>Düzenle</a>
                            <a href='yazilimlar.php?action=delete&id=" . $row['id'] . "' onclick='return confirm(\"Bu yazılımı silmek istediğinize emin misiniz?\")' class='btn-delete'>Sil</a>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='4'>Henüz hiç yazılım eklenmemiş.</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>