<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 

// ID parametresi var mı ve geçerli mi?
if(!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: yazilimlar.php");
    exit();
}

$yazilim_id = intval($_GET['id']);

// Form gönderildiyse güncelleme işlemini yap
if (isset($_POST['yazilim_guncelle'])) {
    $yazilim_adi = trim($_POST['yazilim_adi']);
    $guncel_versiyon = trim($_POST['guncel_versiyon']);
    $guncelleme_linki = trim($_POST['guncelleme_linki']);

    if (!empty($yazilim_adi)) {
        $stmt = $conn->prepare("UPDATE yazilimlar SET yazilim_adi = ?, guncel_versiyon = ?, guncelleme_linki = ? WHERE id = ?");
        $stmt->bind_param("sssi", $yazilim_adi, $guncel_versiyon, $guncelleme_linki, $yazilim_id);
        if ($stmt->execute()) {
            $success = "Yazılım bilgileri başarıyla güncellendi.";
        } else {
            $error = "Hata: Yazılım güncellenemedi.";
        }
        $stmt->close();
    } else {
        $error = "Yazılım adı boş bırakılamaz.";
    }
}

// Veritabanından mevcut yazılım bilgilerini çek
$stmt = $conn->prepare("SELECT id, yazilim_adi, guncel_versiyon, guncelleme_linki, eklenme_tarihi FROM yazilimlar WHERE id = ?");
$stmt->bind_param("i", $yazilim_id);
$stmt->execute();
$stmt->store_result(); // get_result() yerine bunu kullanıyoruz

if($stmt->num_rows === 1) {
    // Sütunları değişkenlere bağlıyoruz
    $stmt->bind_result($id, $yazilim_adi, $guncel_versiyon, $guncelleme_linki, $eklenme_tarihi);
    $stmt->fetch();
    // HTML formunda kullanmak için bir dizi oluşturuyoruz
    $yazilim = [
        'id' => $id,
        'yazilim_adi' => $yazilim_adi,
        'guncel_versiyon' => $guncel_versiyon,
        'guncelleme_linki' => $guncelleme_linki,
        'eklenme_tarihi' => $eklenme_tarihi
    ];
} else {
    // Yazılım bulunamazsa ana sayfaya yönlendir
    header("Location: yazilimlar.php");
    exit();
}
$stmt->close();
?>

<div class="card">
    <h2>"<?php echo htmlspecialchars($yazilim['yazilim_adi']); ?>" Yazılımını Düzenle</h2>

    <?php if (isset($error)) { echo "<p style='color:red; margin-top:1rem;'>$error</p>"; } ?>
    <?php if (isset($success)) { echo "<p style='color:green; margin-top:1rem;'>$success</p>"; } ?>

    <form action="yazilim_duzenle.php?id=<?php echo $yazilim_id; ?>" method="post" style="margin-top: 1.5rem;">
        <div class="form-group">
            <label for="yazilim_adi">Yazılım Adı</label>
            <input type="text" name="yazilim_adi" id="yazilim_adi" value="<?php echo htmlspecialchars($yazilim['yazilim_adi']); ?>" required>
        </div>
        <div class="form-group">
            <label for="guncel_versiyon">Güncel Versiyon</label>
            <input type="text" name="guncel_versiyon" id="guncel_versiyon" value="<?php echo htmlspecialchars($yazilim['guncel_versiyon']); ?>" placeholder="Örn: 1.2.0">
        </div>
        <div class="form-group">
            <label for="guncelleme_linki">Güncelleme Dosyası İndirme Linki</label>
            <input type="text" name="guncelleme_linki" id="guncelleme_linki" value="<?php echo htmlspecialchars($yazilim['guncelleme_linki']); ?>" placeholder="Örn: https://site.com/dosya.zip">
        </div>
        <input type="submit" name="yazilim_guncelle" value="Bilgileri Güncelle">
    </form>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>