<?php
// Hataları gösterelim ki sorun varsa görelim
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>Otomatik Şifre Sıfırlama Aracı</h1>";

// Veritabanı bağlantısını dahil et
require_once 'inc/db.php';

// Ayarlanacak yeni bilgiler
$hedef_kullanici_adi = 'admin';
$yeni_sifre_duz_metin = 'yeni123'; // Yeni, basit ve akılda kalıcı bir şifre

// Yeni şifreyi HASH'le
$yeni_sifre_hash = password_hash($yeni_sifre_duz_metin, PASSWORD_DEFAULT);

if ($yeni_sifre_hash === false) {
    die("<p style='color:red;'>KRİTİK HATA: Sunucuda password_hash fonksiyonu çalışmıyor. Lütfen hosting firmanızla görüşün.</p>");
}

// Veritabanını güncellemek için hazırlıklı ifade kullanalım
$stmt = $conn->prepare("UPDATE admin_kullanicilar SET sifre_hash = ? WHERE kullanici_adi = ?");
if ($stmt === false) {
    die("<p style='color:red;'>KRİTİK HATA: SQL sorgusu hazırlanamadı. Veritabanı veya tablo adı hatalı olabilir.</p>");
}

$stmt->bind_param('ss', $yeni_sifre_hash, $hedef_kullanici_adi);
$stmt->execute();

// Güncellemenin başarılı olup olmadığını kontrol et
if ($stmt->affected_rows > 0) {
    echo "<p style='color:green; font-size:20px; font-weight:bold;'>BAŞARILI!</p>";
    echo "<p>Şifre başarıyla sıfırlandı.</p>";
    echo "<p><strong>Kullanıcı Adı:</strong> admin</p>";
    echo "<p><strong>Yeni Şifre:</strong> yeni123</p>";
    echo "<p style='color:red; font-weight:bold;'>ŞİMDİ GÜVENLİK İÇİN BU 'sifre_sifirla.php' DOSYASINI SUNUCUDAN SİLİN!</p>";

} else {
    echo "<p style='color:red; font-size:20px; font-weight:bold;'>HATA!</p>";
    echo "<p>Şifre sıfırlanamadı. Muhtemel Sebepler:</p>";
    echo "<ul>";
    echo "<li>Veritabanında <strong>'admin'</strong> adında bir kullanıcı bulunamadı. (Kullanıcı adında büyük/küçük harf veya boşluk olabilir mi?)</li>";
    echo "<li>Şifre zaten <strong>'yeni123'</strong> olarak ayarlıydı.</li>";
    echo "</ul>";
    echo "<p>Lütfen phpMyAdmin'den `admin_kullanicilar` tablosundaki `kullanici_adi` sütununu kontrol edin.</p>";
}

$stmt->close();
$conn->close();
?>