<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 
?>

<style>
    /* Sadece bu sayfaya özel stil kodları */
    .code-block {
        background-color: var(--bg-dark); /* Temaya uygun arkaplan */
        color: #f8f8f2;
        padding: 1.5rem;
        border-radius: 0.75rem;
        border: 1px solid var(--border-dark);
        margin-top: 1rem;
        margin-bottom: 2rem;
        font-family: 'Courier New', Courier, monospace;
        white-space: pre-wrap;
        word-wrap: break-word;
        font-size: 14px;
    }
    .code-block textarea {
        width: 100%;
        height: 250px;
        background-color: transparent;
        color: #f8f8f2;
        border: none;
        font-family: 'Courier New', Courier, monospace;
        font-size: 14px;
        resize: vertical;
    }
    .code-block textarea:focus {
        outline: none;
    }
    .step {
        margin-bottom: 2rem;
        padding-bottom: 2rem;
        border-bottom: 1px solid var(--border-dark);
    }
    .step:last-child {
        border-bottom: none;
        margin-bottom: 0;
        padding-bottom: 0;
    }
    .step h2 {
        color: var(--accent-blue);
        margin-bottom: 0.5rem;
    }
    /* YENİ DÜZENLEME BAŞLANGICI */
    .code-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 1rem;
        margin-bottom: 0.5rem;
    }
    .code-title h3 {
        font-size: 1.1rem;
        color: var(--text-heading);
        margin: 0;
    }
    .code-title p {
        font-size: 0.875rem;
        color: var(--text-light);
        margin: 0.25rem 0 0 0;
    }
    .copy-btn {
        background-color: #374151; /* Tailwind Slate 700 */
        color: var(--text-light);
        border: 1px solid var(--border-dark);
        padding: 0.5rem 1rem;
        border-radius: 0.5rem;
        cursor: pointer;
        font-weight: 500;
        white-space: nowrap; /* Buton yazısı alt satıra inmesin */
        transition: background-color 0.2s;
    }
    /* YENİ DÜZENLEME SONU */
    .copy-btn:hover {
        background-color: #4b5563; /* Tailwind Slate 600 */
    }
</style>

<div class="card">
    <h1>Entegrasyon Rehberi</h1>
    <p>Bu rehber, sattığınız PHP yazılımlarına lisans sistemini nasıl entegre edeceğinizi adım adım anlatır.</p>
</div>

<div class="card">
    <div class="step">
        <h2>Adım 1: Müşteri İçin Lisans Oluşturma</h2>
        <p>
            Öncelikle <strong><a href="lisanslar.php">Lisanslar</a></strong> sayfasından müşteriniz için yeni bir lisans oluşturun. 
            Oluşturulan lisansın <strong>Lisans Kodu</strong>'nu kopyalayın. Bu kodu müşterinize aktivasyon için vereceksiniz.
        </p>
    </div>

    <div class="step">
        <h2>Adım 2: Gerekli Dosyaları Müşteriye Gönderme</h2>
        <p>
            Müşteriye sattığınız yazılımın ana dizinine (<code>config.php</code> dosyasının olduğu yere) aşağıdaki iki dosyayı eklemeniz gerekmektedir. 
            Bu dosyaların kodlarını aşağıdan kopyalayabilirsiniz.
        </p>
        
        <div class="code-header">
            <div class="code-title">
                <h3><code>aktivasyon_ekrani.php</code></h3>
                <p>Müşterinin lisans kodunu gireceği ekrandır.</p>
            </div>
            <button class="copy-btn" onclick="copyToClipboard('aktivasyon_kodu')">Kodu Kopyala</button>
        </div>
        <div class="code-block">
            <textarea id="aktivasyon_kodu" readonly><?php echo htmlspecialchars(file_get_contents('../aktivasyon_ekrani.php')); ?></textarea>
        </div>

        <div class="code-header">
            <div class="code-title">
                <h3><code>lisans_kontrol.php</code></h3>
                <p>Aktivasyon sonrası lisansın geçerliliğini arka planda kontrol eden dosyadır.</p>
            </div>
            <button class="copy-btn" onclick="copyToClipboard('kontrol_kodu')">Kodu Kopyala</button>
        </div>
        <div class="code-block">
            <textarea id="kontrol_kodu" readonly><?php echo htmlspecialchars(file_get_contents('../lisans_kontrol.php')); ?></textarea>
        </div>
    </div>

    <div class="step">
        <h2>Adım 3: <code>config.php</code> Dosyasına Entegrasyon</h2>
        
        <div class="code-header">
            <div class="code-title">
                 <p>
                    Son olarak, müşterinin yazılımındaki merkezi ayar dosyasına (genellikle <code>config.php</code>) aşağıdaki kod bloğunu <strong>dosyanın en başına</strong> ekleyin. 
                    Bu kod, aktivasyon yapılmamışsa aktivasyon ekranını gösterecek, yapılmışsa lisansı kontrol edecektir.
                </p>
            </div>
             <button class="copy-btn" onclick="copyToClipboard('config_kodu')">Kodu Kopyala</button>
        </div>
        <div class="code-block" id="config_kodu_container">
<textarea id="config_kodu" readonly>
<?php
$config_code = <<<'EOD'
<?php
// Session, her şeyden önce, en başta başlatılmalıdır.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// =================================================================
// LİSANS KONTROL SİSTEMİ BAŞLANGICI
// =================================================================

// Lisans sunucunuzun URL'si
define('LISANS_SUNUCUSU_URL', 'https://asoftv10.artuklusoft.net/lisans-sistemi/api/verify.php');

// Gerekli dosyaların yolları
$lisans_dosyasi = __DIR__ . '/.lic_key';
$aktivasyon_dosyasi = __DIR__ . '/aktivasyon_ekrani.php';
$kontrol_dosyasi = __DIR__ . '/lisans_kontrol.php';

// Aktivasyon yapılmış mı?
if (!file_exists($lisans_dosyasi)) {
    // Yapılmamışsa aktivasyon ekranını göster ve dur.
    if (file_exists($aktivasyon_dosyasi)) {
        define('AKTIVASYON_SAYFASI', true);
        require_once $aktivasyon_dosyasi;
        exit();
    } else {
        die('Kritik Sistem Hatasi: aktivasyon_ekrani.php dosyasi bulunamadi!');
    }
}

// Aktivasyon yapılmışsa, lisansı kontrol et.
if (file_exists($kontrol_dosyasi)) {
    require_once $kontrol_dosyasi;
} else {
    die('Kritik Sistem Hatasi: lisans_kontrol.php dosyasi bulunamadi!');
}

// =================================================================
// LİSANS KONTROL SİSTEMİ SONU
// =================================================================


// --- YAZILIMINIZIN DİĞER KODLARI BURADAN SONRA DEVAM EDECEK ---

?>
EOD;
echo htmlspecialchars($config_code);
?>
</textarea>
        </div>
    </div>
</div>

<script>
function copyToClipboard(elementId) {
    const textArea = document.getElementById(elementId);
    textArea.select();
    textArea.setSelectionRange(0, 99999); // For mobile devices

    try {
        document.execCommand('copy');
        alert('Kod panoya kopyalandı!');
    } catch (err) {
        alert('Hata: Kod kopyalanamadı.');
    }
}
</script>

<?php require_once 'inc/footer.php'; ?>