<?php 
// 1. Session'ı başlat ve işlem kodunu header'dan önceye al
session_start();
require_once 'inc/db.php'; 

// Yeni müşteri ekleme
if (isset($_POST['musteri_ekle'])) {
    $ad_soyad = trim($_POST['ad_soyad']);
    $email = trim($_POST['email']);
    $telefon = trim($_POST['telefon']);
    $sifre = trim($_POST['sifre']);

    if (!empty($ad_soyad) && !empty($email) && !empty($sifre)) {
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("INSERT INTO musteriler (ad_soyad, email, sifre, telefon) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssss", $ad_soyad, $email, $sifre_hash, $telefon);
            if ($stmt->execute()) {
                header("Location: musteriler.php");
                exit();
            } else { $error = "Hata: Müşteri eklenemedi. Bu e-posta adresi zaten kayıtlı olabilir."; }
            $stmt->close();
        } else { $error = "Lütfen geçerli bir e-posta adresi girin."; }
    } else { $error = "Ad Soyad, E-posta ve Şifre alanları boş bırakılamaz."; }
}

// Silme işlemi
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id_to_delete = intval($_GET['id']);
    $stmt = $conn->prepare("DELETE FROM musteriler WHERE id = ?");
    $stmt->bind_param("i", $id_to_delete);
    if ($stmt->execute()) {
        header("Location: musteriler.php");
        exit();
    } else { $error = "Hata: Müşteri silinemedi."; }
    $stmt->close();
}

// 2. HTML içeriğini başlatan dosyaları şimdi dahil et
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 
?>

<div class="card">
    <h2>Yeni Müşteri Ekle</h2>
    <?php if (isset($error)) { echo "<p style='color:red;'>$error</p>"; } ?>
    <form action="musteriler.php" method="post">
        <div class="form-group">
            <label for="ad_soyad">Ad Soyad</label>
            <input type="text" name="ad_soyad" id="ad_soyad" required>
        </div>
        <div class="form-group">
            <label for="email">E-posta Adresi</label>
            <input type="email" name="email" id="email" required>
        </div>
        <div class="form-group">
            <label for="sifre">Şifre</label>
            <input type="password" name="sifre" id="sifre" required>
        </div>
        <div class="form-group">
            <label for="telefon">Telefon (İsteğe Bağlı)</label>
            <input type="text" name="telefon" id="telefon">
        </div>
        <input type="submit" name="musteri_ekle" value="Müşteriyi Ekle">
    </form>
</div>

<div class="card">
    <h2>Mevcut Müşteriler</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Ad Soyad</th>
                <th>E-posta</th>
                <th>Telefon</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $result = $conn->query("SELECT * FROM musteriler ORDER BY id DESC");
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $row['id'] . "</td>";
                    echo "<td>" . htmlspecialchars($row['ad_soyad']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['email']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['telefon']) . "</td>";
                    echo "<td>
                            <a href='musteri_duzenle.php?id=" . $row['id'] . "' style='margin-right:15px;'>Düzenle</a>
                            <a href='musteriler.php?action=delete&id=" . $row['id'] . "' onclick='return confirm(\"Bu müşteriyi silmek istediğinize emin misiniz?\")' class='btn-delete'>Sil</a>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='5'>Henüz hiç müşteri eklenmemiş.</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>