<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 

if(!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: musteriler.php");
    exit();
}
$musteri_id = intval($_GET['id']);

// Form gönderildiyse
if (isset($_POST['musteri_guncelle'])) {
    $ad_soyad = trim($_POST['ad_soyad']);
    $email = trim($_POST['email']);
    $telefon = trim($_POST['telefon']);
    $sifre = trim($_POST['sifre']);

    if (!empty($ad_soyad) && !empty($email)) {
        // Eğer yeni bir şifre girildiyse, hash'le. Girilmediyse eski şifreyi koru.
        if (!empty($sifre)) {
            $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE musteriler SET ad_soyad = ?, email = ?, telefon = ?, sifre = ? WHERE id = ?");
            $stmt->bind_param("ssssi", $ad_soyad, $email, $telefon, $sifre_hash, $musteri_id);
        } else {
            $stmt = $conn->prepare("UPDATE musteriler SET ad_soyad = ?, email = ?, telefon = ? WHERE id = ?");
            $stmt->bind_param("sssi", $ad_soyad, $email, $telefon, $musteri_id);
        }

        if ($stmt->execute()) {
            $success = "Müşteri bilgileri başarıyla güncellendi.";
        } else {
            $error = "Hata: Müşteri güncellenemedi. E-posta adresi başkası tarafından kullanılıyor olabilir.";
        }
        $stmt->close();
    } else {
        $error = "Ad Soyad ve E-posta alanları boş bırakılamaz.";
    }
}

// Veritabanından mevcut müşteri bilgilerini çek
$stmt = $conn->prepare("SELECT * FROM musteriler WHERE id = ?");
$stmt->bind_param("i", $musteri_id);
$stmt->execute();
$stmt->store_result();
if($stmt->num_rows === 1) {
    $stmt->bind_result($id, $ad_soyad, $email, $sifre_hash, $telefon, $kayit_tarihi);
    $stmt->fetch();
    $musteri = [
        'id' => $id, 'ad_soyad' => $ad_soyad, 'email' => $email,
        'telefon' => $telefon, 'kayit_tarihi' => $kayit_tarihi
    ];
} else {
    header("Location: musteriler.php");
    exit();
}
$stmt->close();
?>

<div class="card">
    <h2>"<?php echo htmlspecialchars($musteri['ad_soyad']); ?>" Müşterisini Düzenle</h2>

    <?php if (isset($error)) { echo "<p style='color:red; margin-top:1rem;'>$error</p>"; } ?>
    <?php if (isset($success)) { echo "<p style='color:green; margin-top:1rem;'>$success</p>"; } ?>

    <form action="musteri_duzenle.php?id=<?php echo $musteri_id; ?>" method="post" style="margin-top: 1.5rem;">
        <div class="form-group">
            <label for="ad_soyad">Ad Soyad</label>
            <input type="text" name="ad_soyad" id="ad_soyad" value="<?php echo htmlspecialchars($musteri['ad_soyad']); ?>" required>
        </div>
        <div class="form-group">
            <label for="email">E-posta Adresi</label>
            <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($musteri['email']); ?>" required>
        </div>
        <div class="form-group">
            <label for="telefon">Telefon</label>
            <input type="text" name="telefon" id="telefon" value="<?php echo htmlspecialchars($musteri['telefon']); ?>">
        </div>
        <div class="form-group">
            <label for="sifre">Yeni Şifre (Değiştirmek istemiyorsanız boş bırakın)</label>
            <input type="password" name="sifre" id="sifre">
        </div>
        <input type="submit" name="musteri_guncelle" value="Bilgileri Güncelle">
    </form>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>