<?php
// 1. Session'ı başlat ve işlem kodunu header'dan önceye al
session_start();
require_once 'inc/db.php';

// --- YENİ LİSANS OLUŞTURMA İŞLEMİ ---
if (isset($_POST['lisans_ekle'])) {
    $yazilim_id = intval($_POST['yazilim_id']);
    $musteri_id = intval($_POST['musteri_id']);
    $domain = str_replace(['http://', 'https://', 'www.'], '', trim($_POST['domain']));
    $sure = intval($_POST['sure']);

    if ($yazilim_id > 0 && $musteri_id > 0 && !empty($domain) && $sure > 0) {
        $lisans_kodu = 'ASOFT-' . strtoupper(substr(md5(uniqid(rand(), true)), 0, 4)) . '-' . strtoupper(substr(md5($domain), 0, 4)) . '-' . date('Y');
        $baslangic_tarihi = date('Y-m-d');
        $bitis_tarihi = date('Y-m-d', strtotime("+$sure months"));

        $stmt = $conn->prepare("INSERT INTO lisanslar (yazilim_id, musteri_id, lisans_kodu, lisansli_domain, baslangic_tarihi, bitis_tarihi) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iissss", $yazilim_id, $musteri_id, $lisans_kodu, $domain, $baslangic_tarihi, $bitis_tarihi);
        
        if ($stmt->execute()) {
            header("Location: lisanslar.php");
            exit();
        } else {
            $error = "Hata: Lisans oluşturulamadı.";
        }
        $stmt->close();
    } else {
        $error = "Lütfen tüm alanları doğru bir şekilde doldurun.";
    }
}

// --- LİSANS SİLME VEYA DURUM DEĞİŞTİRME İŞLEMİ ---
if (isset($_GET['action'])) {
    $id = intval($_GET['id']);
    if ($_GET['action'] == 'delete') {
        $stmt = $conn->prepare("DELETE FROM lisanslar WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        header("Location: lisanslar.php");
        exit();
    }
    if ($_GET['action'] == 'status' && isset($_GET['durum'])) {
        $yeni_durum = $_GET['durum'];
        $gecerli_durumlar = ['aktif', 'pasif', 'iptal_edildi'];
        if (in_array($yeni_durum, $gecerli_durumlar)) {
            $stmt = $conn->prepare("UPDATE lisanslar SET durum = ? WHERE id = ?");
            $stmt->bind_param("si", $yeni_durum, $id);
            $stmt->execute();
            header("Location: lisanslar.php");
            exit();
        }
    }
}

// 2. HTML içeriğini başlatan dosyaları şimdi dahil et
require_once 'inc/header.php';
require_once 'inc/nav.php';
?>

<div class="card">
    <h2>Yeni Lisans Oluştur</h2>
    <?php if (isset($error)) { echo "<p style='color:red;'>$error</p>"; } ?>
    <form action="lisanslar.php" method="post">
        <div class="form-group">
            <label for="musteri_id">Müşteri Seçin</label>
            <select name="musteri_id" id="musteri_id" required style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ccc;">
                <option value="">-- Müşteri Seçiniz --</option>
                <?php
                $musteriler = $conn->query("SELECT id, ad_soyad FROM musteriler ORDER BY ad_soyad ASC");
                while ($musteri = $musteriler->fetch_assoc()) {
                    echo "<option value='{$musteri['id']}'>" . htmlspecialchars($musteri['ad_soyad']) . "</option>";
                }
                ?>
            </select>
        </div>
        <div class="form-group">
            <label for="yazilim_id">Yazılım Seçin</label>
            <select name="yazilim_id" id="yazilim_id" required style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ccc;">
                <option value="">-- Yazılım Seçiniz --</option>
                <?php
                $yazilimlar = $conn->query("SELECT id, yazilim_adi FROM yazilimlar ORDER BY yazilim_adi ASC");
                while ($yazilim = $yazilimlar->fetch_assoc()) {
                    echo "<option value='{$yazilim['id']}'>" . htmlspecialchars($yazilim['yazilim_adi']) . "</option>";
                }
                ?>
            </select>
        </div>
        <div class="form-group">
            <label for="domain">Lisanslanacak Domain</label>
            <input type="text" name="domain" id="domain" placeholder="ornekdomain.com" required>
        </div>
        <div class="form-group">
            <label for="sure">Lisans Süresi</label>
            <select name="sure" id="sure" required style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ccc;">
                <option value="12">1 Yıl</option>
                <option value="24">2 Yıl</option>
                <option value="1">1 Ay</option>
                <option value="6">6 Ay</option>
            </select>
        </div>
        <input type="submit" name="lisans_ekle" value="Lisansı Oluştur">
    </form>
</div>

<div class="card">
    <h2>Mevcut Lisanslar</h2>
    <div style="overflow-x:auto;"> <table>
        <thead>
            <tr>
                <th>Yazılım</th>
                <th>Müşteri</th>
                <th>Domain</th>
                <th>Lisans Kodu</th> <th>Bitiş Tarihi</th>
                <th>Durum</th>
                <th style="min-width: 200px;">İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql = "SELECT l.id, l.lisans_kodu, l.lisansli_domain, l.bitis_tarihi, l.durum, 
                           y.yazilim_adi, m.ad_soyad 
                    FROM lisanslar l
                    JOIN yazilimlar y ON l.yazilim_id = y.id
                    JOIN musteriler m ON l.musteri_id = m.id
                    ORDER BY l.id DESC";
            $result = $conn->query($sql);
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($row['yazilim_adi']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['ad_soyad']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['lisansli_domain']) . "</td>";
                    echo "<td><input type='text' value='" . htmlspecialchars($row['lisans_kodu']) . "' readonly onclick='this.select();' style='width: 100%; border: 1px solid #ccc; padding: 5px; cursor: copy; font-size: 12px; min-width: 180px;'></td>";
                    echo "<td>" . date("d.m.Y", strtotime($row['bitis_tarihi'])) . "</td>";
                    echo "<td><strong>" . strtoupper($row['durum']) . "</strong></td>";
                    echo "<td>
                        <select onchange=\"if(this.value) window.location.href=this.value;\">
                            <option value=''>Durum Değiştir</option>
                            <option value='lisanslar.php?action=status&id={$row['id']}&durum=aktif'>Aktif Yap</option>
                            <option value='lisanslar.php?action=status&id={$row['id']}&durum=pasif'>Pasif Yap</option>
                            <option value='lisanslar.php?action=status&id={$row['id']}&durum=iptal_edildi'>İptal Et</option>
                        </select>
                        <a href='lisanslar.php?action=delete&id={$row['id']}' onclick='return confirm(\"Bu lisansı silmek istediğinize emin misiniz?\")' class='btn-delete' style='margin-left:10px;'>Sil</a>
                    </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='7'>Henüz hiç lisans oluşturulmamış.</td></tr>";
            }
            ?>
        </tbody>
    </table>
    </div>
    <style>select { padding: 5px; border-radius: 5px; border: 1px solid #ccc; }</style>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>