<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 

if(!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: kullanicilar.php");
    exit();
}
$kullanici_id = intval($_GET['id']);

// Form gönderildiyse
if (isset($_POST['kullanici_guncelle'])) {
    $kullanici_adi = trim($_POST['kullanici_adi']);
    $sifre = trim($_POST['sifre']);

    if (!empty($kullanici_adi)) {
        // Eğer yeni bir şifre girildiyse, hash'le. Girilmediyse eski şifreyi koru.
        if (!empty($sifre)) {
            $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE admin_kullanicilar SET kullanici_adi = ?, sifre_hash = ? WHERE id = ?");
            $stmt->bind_param("ssi", $kullanici_adi, $sifre_hash, $kullanici_id);
        } else {
            $stmt = $conn->prepare("UPDATE admin_kullanicilar SET kullanici_adi = ? WHERE id = ?");
            $stmt->bind_param("si", $kullanici_adi, $kullanici_id);
        }

        if ($stmt->execute()) {
            $success = "Kullanıcı bilgileri başarıyla güncellendi.";
        } else {
            $error = "Hata: Kullanıcı güncellenemedi. Kullanıcı adı başkası tarafından kullanılıyor olabilir.";
        }
        $stmt->close();
    } else {
        $error = "Kullanıcı adı alanı boş bırakılamaz.";
    }
}

// Veritabanından mevcut kullanıcı bilgilerini çek (DÜZELTİLMİŞ KISIM)
$stmt = $conn->prepare("SELECT kullanici_adi FROM admin_kullanicilar WHERE id = ?");
$stmt->bind_param("i", $kullanici_id);
$stmt->execute();
$stmt->store_result(); // get_result() yerine bunu kullanıyoruz

if($stmt->num_rows === 1) {
    // Sütunları değişkene bağlıyoruz
    $stmt->bind_result($kullanici_adi_db);
    $stmt->fetch();
    // HTML formunda kullanmak için bir dizi oluşturuyoruz
    $kullanici = [
        'kullanici_adi' => $kullanici_adi_db,
    ];
} else {
    // Kullanıcı bulunamazsa ana sayfaya yönlendir
    header("Location: kullanicilar.php");
    exit();
}
$stmt->close();
?>

<div class="card">
    <h2>"<?php echo htmlspecialchars($kullanici['kullanici_adi']); ?>" Kullanıcısını Düzenle</h2>

    <?php if (isset($error)) { echo "<p style='color:red; margin-top:1rem;'>$error</p>"; } ?>
    <?php if (isset($success)) { echo "<p style='color:green; margin-top:1rem;'>$success</p>"; } ?>

    <form action="kullanici_duzenle.php?id=<?php echo $kullanici_id; ?>" method="post" style="margin-top: 1.5rem;">
        <div class="form-group">
            <label for="kullanici_adi">Kullanıcı Adı</label>
            <input type="text" name="kullanici_adi" id="kullanici_adi" value="<?php echo htmlspecialchars($kullanici['kullanici_adi']); ?>" required>
        </div>
        <div class="form-group">
            <label for="sifre">Yeni Şifre (Değiştirmek istemiyorsanız boş bırakın)</label>
            <input type="password" name="sifre" id="sifre">
        </div>
        <input type="submit" name="kullanici_guncelle" value="Bilgileri Güncelle">
    </form>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>