<?php 
require_once 'inc/header.php'; 
require_once 'inc/nav.php'; 

// --- Dashboard Verilerini Çekme ---

// 1. Toplam Yazılım Sayısı
$yazilim_sayisi_sorgu = $conn->query("SELECT COUNT(id) as total FROM yazilimlar");
$yazilim_sayisi = $yazilim_sayisi_sorgu->fetch_assoc()['total'];

// 2. Toplam Müşteri Sayısı
$musteri_sayisi_sorgu = $conn->query("SELECT COUNT(id) as total FROM musteriler");
$musteri_sayisi = $musteri_sayisi_sorgu->fetch_assoc()['total'];

// 3. Toplam Lisans Sayısı
$lisans_sayisi_sorgu = $conn->query("SELECT COUNT(id) as total FROM lisanslar");
$lisans_sayisi = $lisans_sayisi_sorgu->fetch_assoc()['total'];

// 4. Aktif Lisans Sayısı
$aktif_lisans_sayisi_sorgu = $conn->query("SELECT COUNT(id) as total FROM lisanslar WHERE durum = 'aktif'");
$aktif_lisans_sayisi = $aktif_lisans_sayisi_sorgu->fetch_assoc()['total'];

// 5. Açık Destek Talepleri Sayısı
$acik_talepler_sorgu = $conn->query("SELECT COUNT(id) as total FROM destek_talepleri WHERE durum = 'Açık' OR durum = 'Müşteri Yanıtladı'");
$acik_talepler_sayisi = $acik_talepler_sorgu->fetch_assoc()['total'];

// 6. Son 5 Lisansı Çek
$son_lisanslar_sorgu = $conn->query("SELECT l.lisansli_domain, y.yazilim_adi, m.ad_soyad 
                                    FROM lisanslar l
                                    JOIN yazilimlar y ON l.yazilim_id = y.id
                                    JOIN musteriler m ON l.musteri_id = m.id
                                    ORDER BY l.id DESC LIMIT 5");

// 7. YENİ: Son 5 Destek Talebini Çek
$son_talepler_sorgu = $conn->query("
    SELECT dt.id, dt.konu, dt.durum, m.ad_soyad
    FROM destek_talepleri dt
    JOIN musteriler m ON dt.musteri_id = m.id
    ORDER BY dt.id DESC LIMIT 5
");

?>
<style>
    .stat-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 1.5rem; margin-bottom: 2rem; }
    .stat-card { display: flex; align-items: center; gap: 1.5rem; background-color: var(--card-dark); padding: 1.5rem; border-radius: 0.75rem; border: 1px solid var(--border-dark); transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out; }
    .stat-card:hover { transform: translateY(-5px); box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -4px rgba(0,0,0,0.1); }
    .stat-card .icon { flex-shrink: 0; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; border-radius: 50%; background-color: rgba(59, 130, 246, 0.1); }
    .stat-card .icon svg { width: 24px; height: 24px; fill: var(--accent-blue); }
    .stat-card .info .number { font-size: 2rem; font-weight: 700; color: var(--text-heading); }
    .stat-card .info .label { font-size: 0.875rem; color: var(--text-light); }
    /* YENİ: İki tabloyu yan yana koymak için grid yapısı */
    .dashboard-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 2rem;
    }
    /* Mobil için tek sütuna düşür */
    @media (max-width: 1200px) {
        .dashboard-grid {
            grid-template-columns: 1fr;
        }
    }
    .status-badge { padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
    .status-badge.açık, .status-badge.müşteriyanıtladı { background-color: #fef3c7; color: #92400e; }
    .status-badge.cevaplandı { background-color: #d1fae5; color: #065f46; }
    .status-badge.kapatıldı { background-color: #e5e7eb; color: #4b5563; }
</style>

<div class="stat-grid">
    <div class="stat-card">
        <div class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z"/></svg></div>
        <div class="info"><div class="number"><?php echo $yazilim_sayisi; ?></div><div class="label">Toplam Yazılım</div></div>
    </div>
    <div class="stat-card">
        <div class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg></div>
        <div class="info"><div class="number"><?php echo $musteri_sayisi; ?></div><div class="label">Toplam Müşteri</div></div>
    </div>
    <div class="stat-card">
        <div class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21.41 11.58l-9-9C12.05 2.22 11.55 2 11 2H4c-1.1 0-2 .9-2 2v7c0 .55.22 1.05.59 1.42l9 9c.36.36.86.58 1.41.58s1.05-.22 1.41-.59l7-7c.37-.36.59-.86.59-1.41s-.23-1.06-.59-1.42zM13 20.01L4 11V4h7v-.01l9 9-7 7.01z"/><circle cx="6.5" cy="6.5" r="1.5"/></svg></div>
        <div class="info"><div class="number"><?php echo $aktif_lisans_sayisi; ?></div><div class="label">Aktif Lisans</div></div>
    </div>
    <div class="stat-card">
        <div class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 12H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/></svg></div>
        <div class="info"><div class="number"><?php echo $acik_talepler_sayisi; ?></div><div class="label">Açık Destek Talebi</div></div>
    </div>
</div>

<div class="dashboard-grid">
    <div class="card">
        <h2>Son Eklenen Lisanslar</h2>
        <table>
            <thead><tr><th>Müşteri Adı</th><th>Yazılım</th><th>Domain</th></tr></thead>
            <tbody>
                <?php
                if ($son_lisanslar_sorgu->num_rows > 0) {
                    while($row = $son_lisanslar_sorgu->fetch_assoc()) {
                        echo "<tr><td>" . htmlspecialchars($row['ad_soyad']) . "</td><td>" . htmlspecialchars($row['yazilim_adi']) . "</td><td>" . htmlspecialchars($row['domain']) . "</td></tr>";
                    }
                } else {
                    echo "<tr><td colspan='3'>Henüz hiç lisans oluşturulmamış.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <div class="card">
        <h2>Son Açılan Destek Talepleri</h2>
        <table>
            <thead>
                <tr>
                    <th>Müşteri</th>
                    <th>Konu</th>
                    <th>Durum</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($son_talepler_sorgu->num_rows > 0) {
                    while($row = $son_talepler_sorgu->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row['ad_soyad']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['konu']) . "</td>";
                        echo "<td><span class='status-badge " . strtolower(str_replace(' ', '', $row['durum'])) . "'>" . htmlspecialchars($row['durum']) . "</span></td>";
                        echo "<td><a href='talep_detay.php?id=" . $row['id'] . "'>Görüntüle</a></td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='4'>Açık destek talebi bulunmuyor.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php 
$conn->close();
require_once 'inc/footer.php'; 
?>