<?php 
// db.php zaten header.php'de dahil edildi. Tekrar çağırmaya gerek yok.
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<style>
    .sidebar {
        width: 250px;
        background-color: var(--sidebar-dark);
        border-right: 1px solid var(--border-dark);
        padding: 1.5rem;
        display: flex;
        flex-direction: column;
    }
    .sidebar .logo {
        color: var(--text-heading);
        font-size: 1.5rem;
        font-weight: 700;
        text-align: center;
        margin-bottom: 2rem;
        letter-spacing: 1px;
    }
    .sidebar nav {
        flex-grow: 1; 
    }
    .sidebar a {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        color: var(--text-light);
        padding: 0.75rem 1rem;
        text-decoration: none;
        border-radius: 0.5rem;
        margin-bottom: 0.5rem;
        transition: background-color 0.2s, color 0.2s;
    }
    .sidebar a:hover {
        background-color: #374151; 
        color: var(--text-heading);
    }
    .sidebar a.active {
        background-color: var(--accent-blue);
        color: white;
        font-weight: 600;
        box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1);
    }
</style>
<aside class="sidebar">
    <div class="logo">
        <?php if (!empty($AYARLAR['admin_logo']) && file_exists('../' . $AYARLAR['admin_logo'])): ?>
            <img src="../<?php echo htmlspecialchars($AYARLAR['admin_logo']); ?>" alt="Admin Logo" style="max-height: 40px; max-width: 180px;">
        <?php else: ?>
            <?php echo isset($AYARLAR['site_adi']) ? htmlspecialchars($AYARLAR['site_adi']) : 'Asoft Lisans'; ?>
        <?php endif; ?>
    </div>
    <nav>
        <a href="index.php" class="<?php if($currentPage == 'index.php') echo 'active'; ?>">Anasayfa</a>
        <a href="yazilimlar.php" class="<?php if($currentPage == 'yazilimlar.php') echo 'active'; ?>">Yazılımlar</a>
        <a href="musteriler.php" class="<?php if($currentPage == 'musteriler.php') echo 'active'; ?>">Müşteriler</a>
        <a href="lisanslar.php" class="<?php if($currentPage == 'lisanslar.php') echo 'active'; ?>">Lisanslar</a>
        <a href="rehber.php" class="<?php if($currentPage == 'rehber.php') echo 'active'; ?>">Entegrasyon Rehberi</a>
        <a href="destek_talepleri.php" class="<?php if($currentPage == 'destek_talepleri.php') echo 'active'; ?>">Destek Talepleri</a>
        <a href="loglar.php" class="<?php if($currentPage == 'loglar.php') echo 'active'; ?>">İşlem Logları</a>
        <a href="kullanicilar.php" class="<?php if($currentPage == 'kullanicilar.php' || $currentPage == 'kullanici_duzenle.php') echo 'active'; ?>">Kullanıcı Yönetimi</a>
        <a href="ayarlar.php" class="<?php if($currentPage == 'ayarlar.php') echo 'active'; ?>">Site Ayarları</a>
    </nav>
    </aside>
<div class="content-wrapper">
    <header class="header-bar">
        <div class="page-title">
            <?php
                // Sayfa başlığını dosya adına göre otomatik ayarlayalım
                switch ($currentPage) {
                    case 'index.php': echo 'Anasayfa'; break;
                    case 'yazilimlar.php': echo 'Yazılım Yönetimi'; break;
                    case 'musteriler.php': echo 'Müşteri Yönetimi'; break;
                    case 'lisanslar.php': echo 'Lisans Yönetimi'; break;
                    case 'rehber.php': echo 'Entegrasyon Rehberi'; break;
                    case 'kullanicilar.php': echo 'Kullanıcı Yönetimi'; break;
                    case 'kullanici_duzenle.php': echo 'Kullanıcı Düzenle'; break;
                    case 'ayarlar.php': echo 'Site Ayarları'; break; // YENİ EKLENDİ
                    default: echo 'Panel'; break;
                }
            ?>
        </div>
        <div class="user-menu">
            <span>Hoş geldin, <strong><?php echo htmlspecialchars($_SESSION['admin_username']); ?></strong></span>
            <a href="logout.php" class="logout-btn">Güvenli Çıkış</a>
        </div>
    </header>
    <main class="main-content">