<?php
// İşlem kodunu header'dan önceye al
session_start();
require_once 'inc/db.php';

// Ayarları çekmek için bir fonksiyon
function get_settings($conn) {
    $settings = [];
    $result = $conn->query("SELECT ayar_key, ayar_value FROM ayarlar");
    while ($row = $result->fetch_assoc()) {
        $settings[$row['ayar_key']] = $row['ayar_value'];
    }
    return $settings;
}

// Ayarları güncellemek için bir fonksiyon
function update_setting($conn, $key, $value) {
    $stmt = $conn->prepare("UPDATE ayarlar SET ayar_value = ? WHERE ayar_key = ?");
    $stmt->bind_param("ss", $value, $key);
    $stmt->execute();
    $stmt->close();
}

// Dosya yükleme fonksiyonu
function upload_file($file, $setting_key, $conn) {
    if (isset($file) && $file['error'] == 0) {
        $upload_dir = '../uploads/';
        $allowed_types = ['image/png', 'image/jpeg', 'image/gif', 'image/svg+xml', 'image/x-icon'];
        
        if (in_array($file['type'], $allowed_types)) {
            // Güvenlik için dosya adını temizle ve eşsiz yap
            $filename = uniqid() . '-' . basename($file['name']);
            $target_file = $upload_dir . $filename;

            if (move_uploaded_file($file['tmp_name'], $target_file)) {
                // Veritabanına yeni dosya yolunu kaydet
                update_setting($conn, $setting_key, 'uploads/' . $filename);
                return true;
            }
        }
    }
    return false;
}

// Form gönderildiyse
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Metin tabanlı ayarları güncelle
    update_setting($conn, 'site_adi', $_POST['site_adi']);
    update_setting($conn, 'musteri_logo', $_POST['musteri_logo']);

    // Dosyaları yükle
    upload_file($_FILES['admin_logo'], 'admin_logo', $conn);
    upload_file($_FILES['favicon'], 'favicon', $conn);

    header("Location: ayarlar.php?success=1");
    exit();
}

$AYARLAR = get_settings($conn);

require_once 'inc/header.php';
require_once 'inc/nav.php';
?>

<div class="card">
    <h2>Site Ayarları</h2>
    <p>Sistemin genel ayarlarını buradan yönetebilirsiniz.</p>

    <?php if (isset($_GET['success'])) { echo "<p style='color:green; margin-top:1rem;'>Ayarlar başarıyla güncellendi.</p>"; } ?>

    <form action="ayarlar.php" method="post" enctype="multipart/form-data" style="margin-top: 1.5rem;">
        
        <div class="form-group">
            <label for="site_adi">Site Adı / Başlığı</label>
            <input type="text" name="site_adi" id="site_adi" value="<?php echo htmlspecialchars($AYARLAR['site_adi']); ?>" required>
        </div>

        <div class="form-group">
            <label for="admin_logo">Admin Panel Logo (PNG, JPG, SVG)</label>
            <input type="file" name="admin_logo" id="admin_logo" style="padding: 10px; border: 1px solid var(--border-dark); border-radius: 0.5rem; width:100%; background-color:var(--bg-dark)">
            <?php if (!empty($AYARLAR['admin_logo']) && file_exists('../' . $AYARLAR['admin_logo'])): ?>
                <div style="margin-top:10px; padding:15px; background-color:var(--bg-dark); border-radius:8px;">
                    <p>Mevcut Logo:</p>
                    <img src="../<?php echo htmlspecialchars($AYARLAR['admin_logo']); ?>?t=<?php echo time(); ?>" alt="Admin Logo" style="max-height: 50px; background-color: #fff; padding: 5px; border-radius: 5px;">
                </div>
            <?php endif; ?>
        </div>
        
        <div class="form-group">
            <label for="musteri_logo">Müşteri Aktivasyon Ekranı Logo URL'si</label>
            <input type="text" name="musteri_logo" id="musteri_logo" value="<?php echo htmlspecialchars($AYARLAR['musteri_logo']); ?>" placeholder="https://example.com/logo.png" required>
             <p style="font-size:12px; color: var(--text-light); margin-top:5px;">Müşteriye gönderilecek aktivasyon ekranında görünecek logonun tam adresi.</p>
        </div>

        <div class="form-group">
            <label for="favicon">Favicon (PNG, ICO)</label>
            <input type="file" name="favicon" id="favicon" style="padding: 10px; border: 1px solid var(--border-dark); border-radius: 0.5rem; width:100%; background-color:var(--bg-dark)">
             <?php if (!empty($AYARLAR['favicon']) && file_exists('../' . $AYARLAR['favicon'])): ?>
                <div style="margin-top:10px; padding:15px; background-color:var(--bg-dark); border-radius:8px;">
                    <p>Mevcut Favicon:</p>
                    <img src="../<?php echo htmlspecialchars($AYARLAR['favicon']); ?>?t=<?php echo time(); ?>" alt="Favicon" style="max-height: 32px;">
                </div>
            <?php endif; ?>
        </div>

        <input type="submit" value="Ayarları Kaydet">
    </form>
</div>

<?php
$conn->close();
require_once 'inc/footer.php';
?>